## Adding a new key

### generate a new key

	$ umask 077
	$ tmpfile=$(mktemp)
	$ cat > "$tmpfile" << EOF
	Key-Type: RSA
	Key-Length: 4096
	Key-Usage: sign
	Name-Real: Pengutronix Archive Signing Key
	Name-Comment: $(date +%Y)
	Name-Email: archive@pengutronix.de
	Expire-Date: $(date +%Y%m%dT000000 -d "April 14 next year")
	EOF
	$ gpg --batch --passphrase '' --pinentry-mode loopback --generate-key "$tmpfile"
	$ rm "$tmpfile"

TODO: Learn how the non-interactive use of reprepro can be teached to
      work in the presence of a passphrase.

### put new key in pengutronix-archive-keyring

First verify you're working with the right repository and that your base hasn't
been tampered with by verifying the last tag and review all commits since the
last tag.

Then do the following using your own email and name:

	$ DEBEMAIL=b.laessig@pengutronix.de
	$ DEBFULLNAME="Björn Lässig"
	$ export DEBEMAIL DEBFULLNAME
	$ year="$(date +%Y)"
	$ pkgversion="$(date +%Y.%m.%d)"
	$ gpgid=$(gpg --list-key --with-colons "Pengutronix Archive Signing Key ($year)" | awk -F: '$1 == "pub" { print $5 }')
	$ gpg --export "$gpgid" > pengutronix-archive-keyring-$year.gpg
	$ dch -v $pkgversion "add new key $gpgid for $year"
	$ git add debian/changelog pengutronix-archive-keyring-$year.gpg
	$ git commit -m "Add new key $gpgid for $year"

Optionally drop old keys by just deleting them.

	$ oldyear=$(($year - 2))
	$ if test -f pengutronix-archive-keyring-$oldyear.gpg; then
		oldgpgid=$(gpg --no-default-keyring --keyring ./pengutronix-archive-keyring-$oldyear.gpg --list-key --with-colons "Pengutronix Archive Signing Key ($oldyear)" | awk -F: '$1 == "pub" { print $5 }')
		git rm pengutronix-archive-keyring-$oldyear.gpg
		dch -v $pkgversion "drop old key $oldgpgid for $oldyear"
		git add debian/changelog
		git commit -m "Drop old key $oldgpgid for $oldyear"
	fi

### build package

	$ dch --release --distribution unstable ""
	$ git commit -m "Finalize changelog for upload of $pkgversion" debian/changelog
	$ dpkg-buildpackage -F -us -uc

Instead of dpkg-buildpackage the package can be build in a clean chroot using:

	$ sbuild -s -A

Pitfall: In January 2018 when building the package on sid the result was not
installable on Wheezy and older because control.tar was compressed using xz
which isn't supported by Wheezy's dpkg. Building in a Stretch chroot works fine.

### finalize git stuff

	$ git tag -s -m "pengutronix-archive-keyring $pkgversion" "$pkgversion"
	$ git push origin "$pkgversion" HEAD

### update repositories

#### Copy key to archive user

	$ year="$(date +%Y)"
	$ gpgid=$(gpg --list-key --with-colons "Pengutronix Archive Signing Key ($year)" | awk -F: '$1 == "pub" { print $5 }')
	$ gpg --pinentry-mode loopback --export-secret-keys -a $gpgid > /tmp/$gpgid
	$ scp /tmp/$gpgid $archivehost:/tmp
	$ ssh user@$archivehost
	archivehost$ gpg-agent
	archivehost$ gpg --pinentry-mode loopback --import < /tmp/$gpgid

#### Put package in the archive

Put the package into unstable:

	$ pkgversion="$(date +%Y.%m.%d)"
	$ dcmd scp pengutronix-archive-keyring_${pkgversion}_$(dpkg-architecture -q DEB_HOST_ARCH).changes $archivehost:public/incoming

and then copy it from unstable to all other distributions (on the archive host as the archive user with `cwd=~/public`):

	$ for dist in $(sed -n 's/^Suite: //p' conf/distributions | grep -v unstable); do reprepro --export=never copy $dist sid pengutronix-archive-keyring; done

#### Let reprepro use the new key

Execute on the archive host as archive user:

	$ year="$(date +%Y)"
	$ gpgid=$(gpg --list-key --with-colons "Pengutronix Archive Signing Key ($year)" | awk -F: '$1 == "pub" { print $5 }')
	$ for conf in */conf/distributions; do repo=${conf%/conf/distributions}; sed -i "s/^SignWith:.*/& $gpgid/" $conf; reprepro -b "$repo" export; done

TODO: The old key must be removed after some time, otherwise reprepro fails to
sign when the key expires. An icinga test checking the validity of the keys
would be great.

#### Publish new key on debian.pengutronix.de

	$ gpg --export $gpgid > /home/publish/sites/debian.pengutronix.de/DocumentRoot/ptx-archive-key.gpg
	$ touch /home/publish/sites/__sync__/debian.pengutronix.de

#### update debian.pengutronix.de/pengutronix.sources

#### check if signed-by=/usr/share/keyrings/pengutronix-archive-keyring.gpg is _the_ keyring

### reminder for next keyupdate

Add a reminder for the next keyupdate into the todo calendar around January next year.
